<?php
$posts_per_page = $settings['query_posts_per_page'];
$post_categories = $settings['query_post_categories'];
$post_tags = $settings['query_post_tags'];
$show_thumbnail = $settings['layout_show_thumbnail'];
$show_category = $settings['layout_show_category'];
$number_of_categories = $settings['layout_number_of_categories'];
$show_date = $settings['layout_show_date'];
$orderby = $settings['query_orderby'];
$order = $settings['query_order'];
$show_author = $settings['layout_show_author'];
$show_view_count = $settings['layout_show_view_count'];
$show_read_time = $settings['layout_show_read_time'];
$show_readmore = $settings['layout_show_read_more_link'];
$readmore_text = $settings['layout_read_more_text'];
$read_more_icon = $settings['layout_read_more_icon'];
$show_content = $settings['layout_show_content'];
$post_content_crop = isset($settings['layout_post_content_crop']) ? $settings['layout_post_content_crop']['size'] : '20';
$post_format = $settings['query_post_format'];
$category_position = $settings['layout_category_position'];
$video_icon = 'no';
$category_style = $settings['layout_category_style'];
$show_review_rating = $settings['layout_show_review_rating'];
$show_review_rating_style2 = 'no';
$show_review_rating_style1 = 'no';
if ($show_review_rating == 'yes') {
    $review_style = $settings['layout_review_style'];
    if ($review_style == 'style2') {
        $show_review_rating_style2 = 'yes';
    } else {
        $show_review_rating_style1 = 'yes';
    }
}

$args = array(
    'posts_per_page' => $posts_per_page,
    'orderby' => $orderby,
    'order' => $order
);

if (!empty($post_categories)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'terms' => $post_categories,
            'field' => 'id'
        ),
    );
}

if (!empty($post_tags)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_tag',
            'terms' => $post_tags,
            'field' => 'id'
        ),
    );
}

if (in_array('video', $post_format) && !in_array('standard', $post_format)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_format',
            'field' => 'slug',
            'terms' => array('post-format-video'),
            'operator' => 'IN'
        )
    );
}

if ($settings['query_enable_offset'] == 'yes') {
    $args['offset'] = $settings['query_offset_item_num'];
}

$query = get_posts($args);

$desktop_slides_show = (isset($settings['query_slides_to_show'])) ? $settings['query_slides_to_show'] : 3;
$tablet_slide_show = (isset($settings['query_slides_to_show_tablet'])) ? $settings['query_slides_to_show_tablet'] : 2;
$mobile_slide_show = (isset($settings['query_slides_to_show_mobile'])) ? $settings['query_slides_to_show_mobile'] : 1;

$slider_control = [
    'slides_to_show' => [
        'desktop'   => $desktop_slides_show,
        'tablet'   => $tablet_slide_show,
        'mobile'   => $mobile_slide_show,
    ],
    'slide_loop' => ("yes" == $settings['slide_loop']) ? true : false,
    'slide_autoplay' => ("yes" == $settings['slide_autoplay']) ? true : false,
    'slide_autoplay_delay' => $settings['slide_autoplay_delay'],
    'slider_space_between' => $settings['slider_column_gap']['size'],
    'widget_id' => $this->get_id()
];

//passing slider controls to the template file
$slider_controls = \json_encode($slider_control);
?>
<?php if ($query) { ?>

    <div class="qoxag-wrapper qoxag-<?php echo esc_attr($this->get_name()); ?>"
        data-controls="<?php echo esc_attr($slider_controls); ?>">
        <!-- main slider -->


        <div class="swiper qoxag-main-slider-container">
            <div class="swiper-wrapper">
                <?php
                foreach ($query as $post) {
                    $post_title_crop = isset($settings['featured_post_title_crop']) ? $settings['featured_post_title_crop']['size'] : '35';
                    $style_class = $block_style_values['main_layout'];
                    $layout_thumbnail_img_size = $settings['main_slider_img_size_size'];
                    if ($settings['layout_layout_style'] == 'thumb-top') {
                        $video_icon = $settings['layout_show_video_popup_icon'];
                    }
                ?>
                    <div class="swiper-slide">
                        <?php
                        $postid = $post->ID;
                        include QOXAG_CORE . "/elementor/content-parts/content-1.php";
                        ?>
                    </div>
                <?php
                }
                ?>
            </div>
            <!-- content will be here -->
            <?php if ("yes" == $settings['slide_dots']): ?>
                <div class="swiper-pagination"></div>
            <?php endif; ?>

            <?php if ("yes" == $settings['slide_arrows']): ?>
                <div class="swiper-navigation-wrapper">
                    <div class="swiper-button-prev">
                        <?php \Elementor\Icons_Manager::render_icon($settings['slide_arrow_icon_left']); ?>
                    </div>
                    <div class="swiper-button-next">
                        <?php \Elementor\Icons_Manager::render_icon($settings['slide_arrow_icon_right']); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Thumb Slider -->
        <div class="swiper qoxag-thumb-slider-container">
            <div class="swiper-wrapper">
                <?php
                foreach ($query as $post) {
                    $post_title_crop = isset($settings['layout_post_title_crop']) ? $settings['layout_post_title_crop']['size'] : '35';
                    $style_class = $block_style_values['thumb_layout'];
                    $layout_thumbnail_img_size = $settings['layout_thumbnail_img_size_size'];
                ?>
                    <div class="swiper-slide">
                        <?php
                        $postid = $post->ID;
                        include QOXAG_CORE . "/elementor/content-parts/content-1.php";
                        ?>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
    </div>


<?php } ?>